<?php
/* --------------------------------------------------------------
   LegacyTemplateDataLoader.php 2020-02-20
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Layout\Smarty\Loaders;

use Smarty;

/**
 * Class LegacyTemplateDataLoader
 *
 * @package Gambio\Admin\Layout\Smarty\Loaders
 */
class LegacyTemplateDataLoader implements LoaderInterface
{
    /**
     * @inheritDoc
     */
    public function load(Smarty $smarty): void
    {
        // Always deactivate PHP debug bar
        $smarty->assign('debug_bar', false);
        
        // Define old dynamic extension variable with empty string
        $this->addFallbackIfEmpty($smarty, 'dynamic_header_actions');
        $this->addFallbackIfEmpty($smarty, 'dynamic_script_assets');
        $this->addFallbackIfEmpty($smarty, 'dynamic_style_assets');
    }
    
    
    /**
     * Adds an empty string as fallback value for the given key.
     *
     * @param Smarty $smarty
     * @param string $key
     */
    private function addFallbackIfEmpty(Smarty $smarty, string $key): void
    {
        if (null === $smarty->getTemplateVars($key)) {
            $smarty->assign($key, '');
        }
    }
}